# Azure Functions profile.ps1
#
# This profile.ps1 will get executed every "cold start" of your Function App.
# "cold start" occurs when:
#
# * A Function App starts up for the very first time
# * A Function App starts up after being de-allocated due to inactivity
#
# You can define helper functions, run commands, or specify environment variables
# NOTE: any variables defined that are not environment variables will get reset after the first execution

# Authenticate with Azure PowerShell using MSI.
# Remove this if you are not planning on using MSI or Azure PowerShell.
if ($env:MSI_SECRET) {
    Disable-AzContextAutosave -Scope Process | Out-Null
    Connect-AzAccount -Identity
}
# Set path to DLLs
$libPath = "$PSScriptRoot\lib"

# Load required assemblies
Add-Type -Path "$libPath\itext.kernel.dll"
Add-Type -Path "$libPath\itext.io.dll"
Add-Type -Path "$libPath\itext.layout.dll"
Add-Type -Path "$libPath\itext.commons.dll"
Add-Type -Path "$libPath\itext.bouncy-castle-connector.dll"
Add-Type -Path "$libPath\itext.licensing.base.dll"

Add-Type -Path "$libPath\System.Text.Json.dll"
Add-Type -Path "$libPath\Microsoft.Extensions.Logging.dll"
Add-Type -Path "$libPath\Microsoft.Extensions.Options.dll"
Add-Type -Path "$libPath\Microsoft.Extensions.DependencyInjection.Abstractions.dll"
Add-Type -Path "$libPath\Microsoft.Extensions.Primitives.dll"
Add-Type -Path "$libPath\System.Diagnostics.DiagnosticSource.dll"

try {
    # Set local license reporting if license is local reporting or remove this line
    [iText.Licensing.Base.Reporting.LicenseKeyReportingConfigurer]::UseLocalReporting("$PSScriptRoot")

    # Load license file
    $licenseFile = [System.IO.FileInfo]::new("$libPath\[LICENSE-FILE].JSON")
    [iText.Licensing.Base.LicenseKey]::LoadLicenseFile($licenseFile)
	
    Write-Host "License loaded successfully." 
	$infoList = [iText.Licensing.Base.LicenseKey]::GetLoadedLicensesInfo()
	foreach($info in $infoList) {
	Write-Host "License Info :"
	Write-Host ("Product        : " + $info.GetProduct())
    Write-Host ("")
	
	 # Output PDF path
    $outputPath = "$libPath\SP125022.pdf"

    # Create PDF writer and document
    $writer = [iText.Kernel.Pdf.PdfWriter]::new($outputPath)
    $pdfDoc = [iText.Kernel.Pdf.PdfDocument]::new($writer)
    $doc = [iText.Layout.Document]::new($pdfDoc)

    # Add "SP125022" as a paragraph
    $para = [iText.Layout.Element.Paragraph]::new("Creating a PDF using Azure Function in Powershell 7.5")
    $doc.Add($para)

    # Close document
    $doc.Close()
	}
	
}
catch {
   $ex = $_.Exception
    while ($ex) {
        Write-Host "Exception Type: $($ex.GetType().FullName)"
        Write-Host $ex.Message
        Write-Host $ex.StackTrace
        Write-Host ""
        $ex = $ex.InnerException
	}
}
# Uncomment the next line to enable legacy AzureRm alias in Azure PowerShell.
# Enable-AzureRmAlias

# You can also define functions or aliases that can be referenced in any of your PowerShell functions.